<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:msdndomain="http://msdn.microsoft.com/aboutmsdn/rss/domains"
	xmlns:ms="urn:schemas-microsoft-com:xslt"
	xmlns:msxsl="urn:schemas-microsoft-com:xslt"
	xmlns:dt="urn:schemas-microsoft-com:datatypes"
	xmlns:user="foo"
	version="1.0"
>

	<xsl:output method="html"/>

	<xsl:include href="languageStrings.xsl" />

	<msxsl:script implements-prefix="user" language="JScript">
		<![CDATA[
			function fdt(dtString)
			{
				var date = new Date(dtString.item(0).text)
				return date.toLocaleDateString();
			}
			function removeSpecialTags(data)
			{
				data = data.replace(/(<p[^>]*>)|(<li[^>]*>)/gi, "<br \/>");
				return data.replace(/(<img[^>]*>)|(<\/p[^>]*>)|(<\/li[^>]*>)|(<ul[^>]*>)|(<\/ul[^>]*>)|(<ol[^>]*>)/gi, "");
			}
			function removeSize(data)
			{
            	 return data.replace(/<(font)[^>]*>/gi,"").replace(/<(\/font)>/gi, "");
			}
			function checkTag(tag, res)
			{
				var idxO, idxC;
				
				idxO = res.indexOf('<' + tag);
				while (idxO >= 0)
				{
					idxC = res.indexOf(idxO, '</' + tag);
					if (idxC < 0)
					{
						res += '</' + tag + '> ';
					}
					idxO = res.indexOf(idxO + 1, '<' + tag);
				}
				return res;
			}
			function checkTags(res)
			{
				res = checkTag('a', res);
				res = checkTag('A', res);
				res = checkTag('dl', res);
				res = checkTag('DL', res);
				res = checkTag('code', res);
				res = checkTag('CODE', res);
				res = checkTag('pre', res);
				res = checkTag('PRE', res);
				res = checkTag('span', res);
				res = checkTag('SPAN', res);
				res = checkTag('div', res);
				res = checkTag('DIV', res);
				res = checkTag('td', res);
				res = checkTag('TD', res);
				res = checkTag('tr', res);
				res = checkTag('TR', res);
				res = checkTag('table', res);
				res = checkTag('TABLE', res);
				
				return res;
			}
			function trimNextWord(text)
			{
				var idx;
				var nIdx;
				var start;
				var substr;

				substr = text.substr(500);
				idx = substr.indexOf('<');
				if (idx >= 0 && substr.charAt(idx + 1) == '/')
				{
					start = text.substr(0, 500 + idx);
					substr = text.substr(500 + idx);
					return checkTags(start + substr.substr(0, substr.indexOf('>') + 1));
				} else {
					start = text.substr(0, 500);
					idx = substr.indexOf('.') + 1;
					nIdx = substr.indexOf('<'); if (nIdx >= 0 && nIdx < idx) idx = nIdx;
					nIdx = substr.indexOf(')'); if (nIdx >= 0 && nIdx < idx) idx = nIdx;
					return checkTags(text.substr(0, 500 + idx));
				}
			}
		]]>
	</msxsl:script>

	<xsl:template match='/*'>
		<div class="channel">
			<ul>
				<xsl:choose>
					<xsl:when test="count(channel) &gt; 0">
						<xsl:apply-templates select='channel' />
					</xsl:when>
					<xsl:otherwise>
						<li class="item1">
							<div class="title">
								<xsl:value-of select="$error" />
							</div>
							<div class="description">
								<span>
									<xsl:value-of select="$rssFeedNotLoaded" />
								</span>
							</div>
						</li>
					</xsl:otherwise>
				</xsl:choose>
			</ul>
		</div>
	</xsl:template>

	<xsl:template match='channel'>
		<xsl:choose>
			<xsl:when test="count(item) &gt; 0">
				<xsl:apply-templates select="item" />
			</xsl:when>
			<xsl:otherwise>
				<li class="item1">
					<div class="title">
						<xsl:value-of select="$error" />
					</div>
					<div class="description">
						<span>
							<xsl:value-of select="$rssFeedEmpty" />
						</span>
					</div>
				</li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match='item'>
		<xsl:if test="position() &lt; 10 or @ignoreSize = '1'">
			<li class="item0">
			<xsl:if test="position() mod 2 = 0">
				<xsl:attribute name="class">item0</xsl:attribute>
			</xsl:if>
			<xsl:if test="position() mod 2 = 1">
				<xsl:attribute name="class">item1</xsl:attribute>
			</xsl:if>
				<div class="title">
					<xsl:choose>
						<xsl:when test="(link) != ''">
							<a class="title" href="{link}"><xsl:value-of select="title" /></a>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="title" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
				<div class="description">
					<xsl:variable name="Desc" select="user:removeSize(user:removeSpecialTags(normalize-space(description)))" />
					<xsl:variable name="Length" select="string-length($Desc)" />
					<xsl:choose>
						<xsl:when test="$Length &lt;= 500 or @ignoreSize = '1'">
							<span>
								<xsl:value-of select="$Desc" disable-output-escaping="yes" />
							</span>
						</xsl:when>
						<xsl:otherwise>
							<span>
								<xsl:value-of select="user:trimNextWord($Desc)" disable-output-escaping="yes" />
								<helper value="" otherValue=''/>[<a class="title" href="{link}">...</a>]
							</span>
						</xsl:otherwise>
					</xsl:choose>
				</div>
				<xsl:if test='pubDate != ""'>
					<div class="pubDate"><xsl:value-of select="$postedOn" />&#160;<xsl:value-of select="user:fdt(pubDate)" />&#160;
						<xsl:if test='comments != ""'>
							<a class="comments" href="{comments}"><xsl:value-of select="$readComments" /></a>
						</xsl:if>
					</div>
				</xsl:if>
			</li>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>